/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.mixin;

import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.api.ZombieVillagerNameManager;
import io.github.overlordsiii.villagernames.util.VillagerUtil;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3851;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1641.class})
public abstract class ZombieVillagerEntityMixin
extends class_1642
implements class_3851,
ZombieVillagerNameManager {
    private String firstName;
    private String lastName;
    private String fullName;
    private String playerName;

    public ZombieVillagerEntityMixin(class_1299<? extends class_1642> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"finishConversion"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/passive/VillagerEntity;initialize(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/world/LocalDifficulty;Lnet/minecraft/entity/SpawnReason;Lnet/minecraft/entity/EntityData;Lnet/minecraft/nbt/NbtCompound;)Lnet/minecraft/entity/EntityData;")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void returnOriginalVillagerName(class_3218 world, CallbackInfo ci, class_1646 villagerEntity, class_1304[] var3, int var4, int var5) {
        VillagerUtil.removeZombieVillagerName(villagerEntity, (class_1641)this);
    }

    @Override
    public void setFirstName(String name) {
        this.firstName = name;
        this.updateFullName();
    }

    @Override
    public void setLastName(String name) {
        this.lastName = name;
        this.updateFullName();
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public void setPlayerName(String name) {
        this.playerName = name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void updateFullName() {
        StringBuilder builder = new StringBuilder();
        Objects.requireNonNull(this.firstName);
        if (VillagerNames.CONFIG.villagerGeneralConfig.reverseLastNames && VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.lastName).append(" ").append(this.firstName);
        } else if (VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.firstName).append(" ").append(this.lastName);
        } else {
            builder.append(this.firstName);
        }
        this.fullName = builder.toString();
    }

    @Override
    public String getFullName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        return this.fullName;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void serializeData(class_2487 tag, CallbackInfo ci) {
        if (this.firstName != null) {
            tag.method_10582("firstName", this.firstName);
        }
        if (this.fullName != null) {
            tag.method_10582("fullName", this.fullName);
        }
        if (this.lastName != null) {
            tag.method_10582("lastName", this.lastName);
        }
        if (this.playerName != null) {
            tag.method_10582("playerName", this.playerName);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void deserializeData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("firstName")) {
            this.firstName = tag.method_10558("firstName");
        }
        if (tag.method_10545("fullName")) {
            this.fullName = tag.method_10558("fullName");
        }
        if (tag.method_10545("lastName")) {
            this.lastName = tag.method_10558("lastName");
        }
        if (tag.method_10545("playerName")) {
            this.playerName = tag.method_10558("playerName");
        }
    }
}

